<?php /* Template Name: ویرایش پروفایل کاربری */
global $current_user, $wp_roles;
$error = array();    
if ( 'POST' == $_SERVER['REQUEST_METHOD'] && !empty( $_POST['action'] ) && $_POST['action'] == 'update-user' ) {
    if ( !empty($_POST['pass1'] ) && !empty( $_POST['pass2'] ) ) {
        if ( $_POST['pass1'] == $_POST['pass2'] )
            wp_update_user( array( 'ID' => $current_user->ID, 'user_pass' => esc_attr( $_POST['pass1'] ) ) );
        else
            $error[] = __('کلمات عبور همخوانی ندارند. کلمه عبور هر دو فیلد باید یکسان باشند.', 'profile');
    }
    if ( !empty( $_POST['url'] ) )
        wp_update_user( array( 'ID' => $current_user->ID, 'user_url' => esc_url( $_POST['url'] ) ) );
    if ( !empty( $_POST['email'] ) ){
        if (!is_email(esc_attr( $_POST['email'] )))
            $error[] = __('آدرس ایمیل معتبر وارد کنید.', 'profile');
        elseif(email_exists(esc_attr( $_POST['email'] )) != $current_user->id )
            $error[] = __('ایمیل توسط کاربر دیگری استفاده شده است. از ایمیل دیگری استفاده کنید.', 'profile');
        else{
            wp_update_user( array ('ID' => $current_user->ID, 'user_email' => esc_attr( $_POST['email'] )));
        }
    }
    if ( !empty( $_POST['first-name'] ) )
        update_user_meta( $current_user->ID, 'first_name', esc_attr( $_POST['first-name'] ) );
    if ( !empty( $_POST['last-name'] ) )
        update_user_meta($current_user->ID, 'last_name', esc_attr( $_POST['last-name'] ) );
    if ( !empty( $_POST['description'] ) )
        update_user_meta( $current_user->ID, 'description', esc_attr( $_POST['description'] ) );
    if ( count($error) == 0 ) {
        do_action('edit_user_profile_update', $current_user->ID);
        wp_redirect( get_permalink() );
        exit;
    }
}
get_header(''); ?>

<!-- tarlanweb_center -->
<div class="tarlanweb_center">
<?php if(have_posts()) : while(have_posts()) : the_post(); ?>
<?php if (is_user_logged_in()){ global $current_user; get_currentuserinfo(); ?>
<?php get_template_part('inc/breadcrumb'); ?>

<?php get_template_part('inc/profile_right'); ?>
<!-- left_panel_user begin -->
<div class="left_panel_user">
<?php get_template_part('inc/profile_head'); ?>
<div class="article_posts boxes_shadows1">
<div class="rkianoosh_txt">
<?php the_content(''); ?>
<div class="clear"></div>
<?php if(count($error) > 0) echo '<p class="message message-error">'.implode("<br>", $error).'</p>'; ?>
<form method="post" id="adduser" action="<?php the_permalink(); ?>">
<p class="form-username">
<label for="first-name">نام</label>
<input class="text-input" name="first-name" type="text" id="first-name" value="<?php the_author_meta( 'first_name', $current_user->ID ); ?>" />
</p><!-- .form-username --> <br>
<p class="form-username">
<label for="last-name">نام خانوادگی</label>
<input class="text-input" name="last-name" type="text" id="last-name" value="<?php the_author_meta( 'last_name', $current_user->ID ); ?>" />
</p><!-- .form-username --> <br>
<p class="form-email">
<label for="email">آدرس ایمیل *</label>
<input class="text-input" name="email" type="text" id="email" value="<?php the_author_meta( 'user_email', $current_user->ID ); ?>" />
</p><!-- .form-email --> <br>
<p class="form-url">
<label for="url">آدرس وب سایت</label>
<input class="text-input" name="url" type="text" id="url" value="<?php the_author_meta( 'user_url', $current_user->ID ); ?>" />
</p><!-- .form-url --> <br>
<p class="form-password">
<label for="pass1">کلمه عبور *</label>
<input class="text-input" name="pass1" type="password" id="pass1" />
</p><!-- .form-password --> <br>
<p class="form-password">
<label for="pass2">تکرار کلمه عبور *</label>
<input class="text-input" name="pass2" type="password" id="pass2" />
</p><!-- .form-password --> <br>
<p class="form-textarea">
<label for="description">بیوگرافی</label>
<textarea name="description" id="description" rows="3" cols="50"><?php the_author_meta( 'description', $current_user->ID ); ?></textarea>
</p><!-- .form-textarea --> 
<?php do_action('edit_user_profile',$current_user); ?>
<br><p class="form-submit">
<?php echo $referer; ?>
<input name="updateuser" type="submit" id="updateuser" class="submit button" value="بروزرسانی" />
<?php wp_nonce_field( 'update-user' ) ?>
<input name="action" type="hidden" id="action" value="update-user" />
</p><!-- .form-submit -->
</form><!-- #adduser -->
          
<div class="clear"></div>
</div>

<div class="clear"></div>
</div>
<div class="clear"></div>
</div>
<!-- left_panel_user end -->
<?php } else{ ?>
<div class="well">
<?php get_template_part('inc/forms'); ?>
</div>
 <?php } ?>
<?php endwhile; endif; ?>
<div class="clear"></div>
</div>
<!-- tarlanweb_center -->
<div class="clear2"></div>
<?php get_footer(''); ?>